/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include <algorithm>
#include <cctype>
#include <functional>
#include <locale>

namespace std
{
	inline void ltrim(string& s)
	{
		s.erase(s.begin(), find_if(s.begin(), s.end(), [](int c) { return !std::isspace(c); }));
	}

	inline void rtrim(string& s)
	{
		s.erase(find_if(s.rbegin(), s.rend(), [](int c) { return !std::isspace(c); }).base(), s.end());
	}

	// trim from both ends (in place)
	void trim(string& s)
	{
		ltrim(s);
		rtrim(s);
	}
} // namespace std
